package org.codefilarete.stalactite.engine;

import javax.sql.DataSource;

import org.codefilarete.stalactite.sql.Dialect;
import org.codefilarete.stalactite.sql.mysql.MySQLDialectBuilder;
import org.codefilarete.stalactite.sql.test.DatabaseHelper;
import org.codefilarete.stalactite.sql.mysql.test.MySQLDatabaseHelper;
import org.codefilarete.stalactite.sql.mysql.test.MySQLTestDataSourceSelector;

/**
 * @author Guillaume Mary
 */
public class PersisterMySQLTest extends PersisterITTest {
	
	private static final DataSource DATASOURCE = new MySQLTestDataSourceSelector().giveDataSource();
	
	@Override
	public DataSource giveDataSource() {
		return DATASOURCE;
	}
	
	@Override
	protected DatabaseHelper giveDatabaseHelper() {
		return new MySQLDatabaseHelper();
	}
	
	@Override
	Dialect createDialect() {
		return MySQLDialectBuilder.defaultMySQLDialect();
	}
}
